using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace CSharp_Sample
{
	/// <summary>
	/// Form1   Դϴ.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.ComboBox cboPrinterName;
		private System.Windows.Forms.Button btnPrintWindowsFont;
		private System.Windows.Forms.Button btnPrintDeviceFont;
		private System.Windows.Forms.Button btnPrintBMP;
		private System.Windows.Forms.Button btnPrintPCX;
		private System.Windows.Forms.Button btnPrintBarCode;
		private System.Windows.Forms.Button btnPrintLineBox;
		private System.Windows.Forms.Button btnPrintData;
		private System.Windows.Forms.Button btnPrintTime;
		private System.Windows.Forms.Button btnPrintPDF417;
		private System.Windows.Forms.Button btnExit;
		/// <summary>
		/// ʼ ̳ Դϴ.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Windows Form ̳  ʿմϴ.
			//
			InitializeComponent();

			//
			// TODO: InitializeComponent ȣ   ڵ带 ߰մϴ.
			//
			cboPrinterName.Items.Add("LUKHAN Label Printer");
			cboPrinterName.Items.Add("SEWOO Label Printer");
			cboPrinterName.SelectedIndex = 1;
		}

		/// <summary>
		///    ҽ մϴ.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form ̳ʿ  ڵ
		/// <summary>
		/// ̳  ʿ ޼Դϴ.
		///  ޼  ڵ   ʽÿ.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.cboPrinterName = new System.Windows.Forms.ComboBox();
			this.btnPrintWindowsFont = new System.Windows.Forms.Button();
			this.btnPrintDeviceFont = new System.Windows.Forms.Button();
			this.btnPrintBMP = new System.Windows.Forms.Button();
			this.btnPrintPCX = new System.Windows.Forms.Button();
			this.btnPrintBarCode = new System.Windows.Forms.Button();
			this.btnPrintLineBox = new System.Windows.Forms.Button();
			this.btnPrintData = new System.Windows.Forms.Button();
			this.btnPrintTime = new System.Windows.Forms.Button();
			this.btnPrintPDF417 = new System.Windows.Forms.Button();
			this.btnExit = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 40);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(128, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "Printer Driver Name : ";
			// 
			// cboPrinterName
			// 
			this.cboPrinterName.Location = new System.Drawing.Point(160, 36);
			this.cboPrinterName.Name = "cboPrinterName";
			this.cboPrinterName.Size = new System.Drawing.Size(192, 20);
			this.cboPrinterName.TabIndex = 1;
			// 
			// btnPrintWindowsFont
			// 
			this.btnPrintWindowsFont.Location = new System.Drawing.Point(16, 80);
			this.btnPrintWindowsFont.Name = "btnPrintWindowsFont";
			this.btnPrintWindowsFont.Size = new System.Drawing.Size(160, 32);
			this.btnPrintWindowsFont.TabIndex = 2;
			this.btnPrintWindowsFont.Text = "Print Windows Font";
			this.btnPrintWindowsFont.Click += new System.EventHandler(this.btnPrintWindowsFont_Click);
			// 
			// btnPrintDeviceFont
			// 
			this.btnPrintDeviceFont.Location = new System.Drawing.Point(192, 80);
			this.btnPrintDeviceFont.Name = "btnPrintDeviceFont";
			this.btnPrintDeviceFont.Size = new System.Drawing.Size(160, 32);
			this.btnPrintDeviceFont.TabIndex = 3;
			this.btnPrintDeviceFont.Text = "Print Device Font";
			this.btnPrintDeviceFont.Click += new System.EventHandler(this.btnPrintDeviceFont_Click);
			// 
			// btnPrintBMP
			// 
			this.btnPrintBMP.Location = new System.Drawing.Point(16, 128);
			this.btnPrintBMP.Name = "btnPrintBMP";
			this.btnPrintBMP.Size = new System.Drawing.Size(160, 32);
			this.btnPrintBMP.TabIndex = 4;
			this.btnPrintBMP.Text = "Print BMP";
			this.btnPrintBMP.Click += new System.EventHandler(this.btnPrintBMP_Click);
			// 
			// btnPrintPCX
			// 
			this.btnPrintPCX.Location = new System.Drawing.Point(192, 128);
			this.btnPrintPCX.Name = "btnPrintPCX";
			this.btnPrintPCX.Size = new System.Drawing.Size(160, 32);
			this.btnPrintPCX.TabIndex = 5;
			this.btnPrintPCX.Text = "Print PCX";
			this.btnPrintPCX.Click += new System.EventHandler(this.btnPrintPCX_Click);
			// 
			// btnPrintBarCode
			// 
			this.btnPrintBarCode.Location = new System.Drawing.Point(16, 176);
			this.btnPrintBarCode.Name = "btnPrintBarCode";
			this.btnPrintBarCode.Size = new System.Drawing.Size(160, 32);
			this.btnPrintBarCode.TabIndex = 6;
			this.btnPrintBarCode.Text = "Print BarCode(1D,2D)";
			this.btnPrintBarCode.Click += new System.EventHandler(this.btnPrintBarCode_Click);
			// 
			// btnPrintLineBox
			// 
			this.btnPrintLineBox.Location = new System.Drawing.Point(192, 176);
			this.btnPrintLineBox.Name = "btnPrintLineBox";
			this.btnPrintLineBox.Size = new System.Drawing.Size(160, 32);
			this.btnPrintLineBox.TabIndex = 7;
			this.btnPrintLineBox.Text = "Print Line / Box";
			this.btnPrintLineBox.Click += new System.EventHandler(this.btnPrintLineBox_Click);
			// 
			// btnPrintData
			// 
			this.btnPrintData.Location = new System.Drawing.Point(16, 224);
			this.btnPrintData.Name = "btnPrintData";
			this.btnPrintData.Size = new System.Drawing.Size(160, 32);
			this.btnPrintData.TabIndex = 8;
			this.btnPrintData.Text = "Print Date";
			this.btnPrintData.Click += new System.EventHandler(this.btnPrintData_Click);
			// 
			// btnPrintTime
			// 
			this.btnPrintTime.Location = new System.Drawing.Point(192, 224);
			this.btnPrintTime.Name = "btnPrintTime";
			this.btnPrintTime.Size = new System.Drawing.Size(160, 32);
			this.btnPrintTime.TabIndex = 9;
			this.btnPrintTime.Text = "Print Time";
			this.btnPrintTime.Click += new System.EventHandler(this.btnPrintTime_Click);
			// 
			// btnPrintPDF417
			// 
			this.btnPrintPDF417.Location = new System.Drawing.Point(16, 272);
			this.btnPrintPDF417.Name = "btnPrintPDF417";
			this.btnPrintPDF417.Size = new System.Drawing.Size(160, 32);
			this.btnPrintPDF417.TabIndex = 10;
			this.btnPrintPDF417.Text = "Print PDF417";
			this.btnPrintPDF417.Click += new System.EventHandler(this.btnPrintPDF417_Click);
			// 
			// btnExit
			// 
			this.btnExit.Location = new System.Drawing.Point(192, 272);
			this.btnExit.Name = "btnExit";
			this.btnExit.Size = new System.Drawing.Size(160, 32);
			this.btnExit.TabIndex = 12;
			this.btnExit.Text = "Program Exit";
			this.btnExit.Click += new System.EventHandler(this.btnExit_Click);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 14);
			this.ClientSize = new System.Drawing.Size(376, 334);
			this.Controls.Add(this.btnExit);
			this.Controls.Add(this.btnPrintPDF417);
			this.Controls.Add(this.btnPrintTime);
			this.Controls.Add(this.btnPrintData);
			this.Controls.Add(this.btnPrintLineBox);
			this.Controls.Add(this.btnPrintBarCode);
			this.Controls.Add(this.btnPrintPCX);
			this.Controls.Add(this.btnPrintBMP);
			this.Controls.Add(this.btnPrintDeviceFont);
			this.Controls.Add(this.btnPrintWindowsFont);
			this.Controls.Add(this.cboPrinterName);
			this.Controls.Add(this.label1);
			this.Name = "Form1";
			this.Text = "LK-Bxx SDK Test Program";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// ش  α׷  Դϴ.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void btnPrintWindowsFont_Click(object sender, System.EventArgs e)
		{
			long rtn;
			int nHeight;
			int nWidth;
			int x,y;

			/* 1. LK_OpenPrinter() */
			if(LKBPRINT.LK_OpenPrinter(cboPrinterName.Text) != LKBPRINT.LK_SUCCESS)
			{
				return;
			}

			/* 2. LK_SetupPrinter() */
#if TRUE // Gap Test
			rtn=LKBPRINT.LK_SetupPrinter("101.6",	// 10 ~ 104 (Unit is mm)
				"152.4", 		// 5 ~ 350 (Unit is mm)
				0,				// 0=Label with Gap, 1=Label with Black Mark, 2=Label with Continuous.
				"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
				"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
				8,				// 0 ~ 15
				6,				// 2 ~ 6 (Unit is Inch)
				1				// 1 ~ 9999 copies
				);
#else // BlackMark Test
	rtn=LKBPRINT.LK_SetupPrinter("101.6",	// 10 ~ 104 (Unit is mm)
					"82", 		// 5 ~ 350 (Unit is mm)
					1,				// 0=Label with Gap, 1=Label width Black Mark
					"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
					"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
					8,				// 0 ~ 15
					6,				// 2 ~ 6 (Unit is Inch)
					1				// 1 ~ 9999 copies
					);
#endif
			if(rtn != LKBPRINT.LK_SUCCESS)
			{
				LKBPRINT.LK_ClosePrinter();
				return;
			}

			/* 3-1. page 1 test */
			LKBPRINT.LK_StartPage();
			nHeight=31;
			x=80;
			//		y=240;
			y=180;
			LKBPRINT.LK_PrintWindowsFont(x,y,0,nHeight,0,0,0,"Arial","Korea Mountain & River"); y+=80;
			LKBPRINT.LK_PrintWindowsFont(x,y,0,nHeight,1,0,0,"Arial","Korea Mountain & River"); y+=80;
			LKBPRINT.LK_PrintWindowsFont(x,y,0,nHeight,0,1,0,"Arial","Korea Mountain & River"); y+=80;
			LKBPRINT.LK_PrintWindowsFont(x,y,0,nHeight,1,1,0,"Arial","Korea Mountain & River"); y+=80;
			LKBPRINT.LK_PrintWindowsFont(x,y,0,nHeight,0,1,1,"Arial","Korea Mountain & River"); y+=80;
			LKBPRINT.LK_PrintWindowsFont(x,y,0,nHeight,1,1,1,"Arial","Korea Mountain & River"); y+=80;

			nWidth=24;
			LKBPRINT.LK_PrintWindowsFontPitch(x,y,0,nHeight,nWidth,1,1,1,"Arial","Korea Mountain & River"); y+=80;
			LKBPRINT.LK_EndPage();

			/* 4. LK_ClosePrinter() */
			LKBPRINT.LK_ClosePrinter();
		}

		private void btnPrintDeviceFont_Click(object sender, System.EventArgs e)
		{
			long rtn;
			int x,y;
			string PrinterName;
			string test_str="SEWOO TECH";
			/* 1. LK_OpenPrinter() */
			if(LKBPRINT.LK_OpenPrinter(cboPrinterName.Text) != LKBPRINT.LK_SUCCESS)
			{
				return;
			}

			PrinterName = cboPrinterName.Text.ToString();

			/* 2. LK_SetupPrinter() */
			rtn=LKBPRINT.LK_SetupPrinter("101.6", 	// 10~104 (Unit is mm)
				"152.4", 		// 5~350 (Unit is mm)
				0,				// 0=Label with Gap, 1=Label with Black Mark, 2=Label with Continuous.
				"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
				"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
				8,				// 0 ~ 15
				6,				// 2 ~ 6 (Unit is Inch)
				1				// 1 ~ 9999 copies
				);

			if(rtn != LKBPRINT.LK_SUCCESS)
			{
				LKBPRINT.LK_ClosePrinter();
				return;
			}

			/* 3-1. page 1 test */
			LKBPRINT.LK_StartPage();
			x=50*8;
			y=50*8;
			/* 0  */
			LKBPRINT.LK_PrintDeviceFont(x,y,0,3,1,1,0,PrinterName);
			/* 90  */
			LKBPRINT.LK_PrintDeviceFont(x,y,90,3,1,1,0,PrinterName);
			/* 180  */
			LKBPRINT.LK_PrintDeviceFont(x,y,180,3,1,1,0,PrinterName);
			/* 270  */
			LKBPRINT.LK_PrintDeviceFont(x,y,270,3,1,1,0,PrinterName);
			/* reverse */
			x=10*8;
			y=90*8;
			LKBPRINT.LK_PrintDeviceFont(x,y,0,3,2,2,1,PrinterName);
			/* reverse */
			y=100*8;
			LKBPRINT.LK_PrintDeviceFont(x,y,0,1,1,1,0,PrinterName);
			y += 5*8;
			LKBPRINT.LK_PrintDeviceFont(x,y,0,2,1,1,0,PrinterName);
			y += 6*8;
			LKBPRINT.LK_PrintDeviceFont(x,y,0,3,1,1,0,PrinterName);
			y += 7*8;
			LKBPRINT.LK_PrintDeviceFont(x,y,0,4,1,1,0,PrinterName);
			y += 8*8;
			LKBPRINT.LK_PrintDeviceFont(x,y,0,5,1,1,0,test_str);
			LKBPRINT.LK_EndPage();

			/* 4. LK_ClosePrinter() */
			LKBPRINT.LK_ClosePrinter();
		}

		private void btnPrintBMP_Click(object sender, System.EventArgs e)
		{
			long rtn;
			int x,y;

			/* 1. LK_OpenPrinter() */
			if(LKBPRINT.LK_OpenPrinter(cboPrinterName.Text) != LKBPRINT.LK_SUCCESS)
			{
				return;
			}

			/* 2. LK_SetupPrinter() */
			rtn=LKBPRINT.LK_SetupPrinter("101.6", 	// 10~104 (Unit is mm)
				"152.4", 		// 5~350 (Unit is mm)
				0,				// 0=Label with Gap, 1=Label with Black Mark, 2=Label with Continuous.
				"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
				"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
				8,				// 0 ~ 15
				6,				// 2 ~ 6 (Unit is Inch)
				1				// 1 ~ 9999 copies
				);

			if(rtn != LKBPRINT.LK_SUCCESS)
			{
				LKBPRINT.LK_ClosePrinter();
				return;
			}

			/* 3-1. page 1 test */
			x=10*8;
			y=10*8;
			LKBPRINT.LK_StartPage();
			LKBPRINT.LK_PrintBMP(x,y,"Red.bmp");		
			LKBPRINT.LK_EndPage();

			/* 4. LK_ClosePrinter() */
			LKBPRINT.LK_ClosePrinter();
		}

		private void btnPrintPCX_Click(object sender, System.EventArgs e)
		{
			long rtn;
			int x,y;

			/* 1. LK_OpenPrinter() */
			if(LKBPRINT.LK_OpenPrinter(cboPrinterName.Text) != LKBPRINT.LK_SUCCESS)
			{
				return;
			}

			/* 2. LK_SetupPrinter() */
			rtn=LKBPRINT.LK_SetupPrinter("101.6", 	// 10~104 (Unit is mm)
				"152.4", 		// 5~350 (Unit is mm)
				0,				// 0=Label with Gap, 1=Label with Black Mark, 2=Label with Continuous.
				"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
				"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
				8,				// 0 ~ 15
				6,				// 2 ~ 6 (Unit is Inch)
				1				// 1 ~ 9999 copies
				);

			if(rtn != LKBPRINT.LK_SUCCESS)
			{
				LKBPRINT.LK_ClosePrinter();
				return;
			}

			/* 3-1. page 1 test */
			x=10*8;
			y=10*8;
			LKBPRINT.LK_StartPage();
			LKBPRINT.LK_PrintPCX(x,y,"RING.PCX");	
			LKBPRINT.LK_EndPage();

			/* 4. LK_ClosePrinter() */
			LKBPRINT.LK_ClosePrinter();
		}

		private void btnPrintBarCode_Click(object sender, System.EventArgs e)
		{
			long rtn;
			int x,y,BarHeight;

			int	xdots, model; // ydots;
//			int xwidthdot, ywidthdot;

			string code_128a="6015343013149";
			string test_str3="Code128 AutoA";

			string QRCode_data="SEWOO QRCode TEST";
			string DataMatrix_data="SEWOO DataMatrix TEST";
			string	TwoBAR_Command;

			/* 1. LK_OpenPrinter() */
			if(LKBPRINT.LK_OpenPrinter(cboPrinterName.Text) != LKBPRINT.LK_SUCCESS)
			{
				return;
			}

			/* 2. LK_SetupPrinter() */
			rtn=LKBPRINT.LK_SetupPrinter("101.6", 	// 10~104 (Unit is mm)
				"152.4", 		// 5~350 (Unit is mm)
				0,				// 0=Label with Gap, 1=Label with Black Mark, 2=Label with Continuous.
				"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
				"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
				8,				// 0 ~ 15
				6,				// 2 ~ 6 (Unit is Inch)
				1				// 1 ~ 9999 copies
				);

			if(rtn != LKBPRINT.LK_SUCCESS)
			{
				LKBPRINT.LK_ClosePrinter();
				return;
			}

			/* 3-1. page 1 test */
			LKBPRINT.LK_StartPage();
			BarHeight=12*8;	// 12mm
			x=10*8;
			y=10*8;
			LKBPRINT.LK_PrintDeviceFont(x,y,0,3,1,1,0,test_str3);
			/* 0  */
			x=50*8;
			y=60*8;
			LKBPRINT.LK_PrintBarCode(x,y,0,"2",2,4,BarHeight,1,code_128a);
			/* 90  */
			x=50*8-2*8;
			y=60*8;
			LKBPRINT.LK_PrintBarCode(x,y,90,"2",2,4,BarHeight,1,code_128a);
			/* 1800  */
			x=50*8-2*8;
			y=60*8-2*8;
			LKBPRINT.LK_PrintBarCode(x,y,180,"2",2,4,BarHeight,1,code_128a);
			/* 270  */
			x=50*8;
			y=60*8-2*8;
			LKBPRINT.LK_PrintBarCode(x,y,270,"2",2,4,BarHeight,1,code_128a);

			// QR Code
			// bx,y,Q,1,z,L,"DATA"
			// x = x position.
			// y = y position
			// z = Cell Size. (2 ~ 16)
			// L = ECC Level(L or M or Q or H)
			x=60*8;
			y=100*8;
			xdots = 3;
			model = 1;
			TwoBAR_Command = string.Format("b{0},{1},Q,{2},{3},L,\"{4}\"\r\n", x, y, model, xdots, QRCode_data);
			LKBPRINT.LK_DirectCommand(TwoBAR_Command);

			// DataMatrix
			// bx,y,D,r,c,"DATA"
			// x = x position.
			// y = y position
			// r = Rotate. (0 ~ 3)
			// c = Cell size
			x=80*8;
			y=100*8;
			xdots = 3;
			TwoBAR_Command = string.Format("b{0},{1},D,{2},{3},\"{4}\"\r\n", x, y, 0, xdots, DataMatrix_data);
			LKBPRINT.LK_DirectCommand(TwoBAR_Command);

			LKBPRINT.LK_EndPage();

			/* 4. LK_ClosePrinter() */
			LKBPRINT.LK_ClosePrinter();
		}

		private void btnPrintLineBox_Click(object sender, System.EventArgs e)
		{
			long rtn;
			int x,y;
			int	nHeight;

			/* 1. LK_OpenPrinter() */
			if(LKBPRINT.LK_OpenPrinter(cboPrinterName.Text) != LKBPRINT.LK_SUCCESS)
			{
				return;
			}

			/* 2. LK_SetupPrinter() */
			rtn=LKBPRINT.LK_SetupPrinter("101.6", 	// 10~104 (Unit is mm)
				"152.4", 		// 5~350 (Unit is mm)
				0,				// 0=Label with Gap, 1=Label with Black Mark, 2=Label with Continuous.
				"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
				"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
				8,				// 0 ~ 15
				6,				// 2 ~ 6 (Unit is Inch)
				1				// 1 ~ 9999 copies
				);

			if(rtn != LKBPRINT.LK_SUCCESS)
			{
				LKBPRINT.LK_ClosePrinter();
				return;
			}

			/* 3-1. page 1 test */
			LKBPRINT.LK_StartPage();

			x=10*8;
			y=10*8;
			LKBPRINT.LK_PrintLine(x,y,50*8,2*8);

			x=10*8;
			y=15*8;
			LKBPRINT.LK_DrawLine(LKBPRINT.PS_SOLID, x,y,x+50*8, y, 16);

			x=10*8;
			y=20*8;
			LKBPRINT.LK_PrintDiagonalLine(x,y,x+50*8,y+30*8,2*8);

			x=20*8;
			y=20*8;
			LKBPRINT.LK_DrawLine(LKBPRINT.PS_SOLID, x,y,x+50*8,y+30*8, 16);

			x=30*8;
			y=20*8;
			LKBPRINT.LK_DrawLine(LKBPRINT.PS_DASH, x,y,x+50*8,y+30*8, 4);

			x=40*8;
			y=20*8;
			LKBPRINT.LK_DrawLine(LKBPRINT.PS_DOT, x,y,x+50*8,y+30*8, 4);

			x=50*8;
			y=20*8;
			LKBPRINT.LK_DrawLine(LKBPRINT.PS_DASHDOT, x,y,x+50*8,y+30*8, 4);

			x=60*8;
			y=20*8;
			LKBPRINT.LK_DrawLine(LKBPRINT.PS_DASHDOTDOT, x,y,x+30*8,y+18*8, 4);

			x=70*8;
			y=20*8;
			LKBPRINT.LK_DrawLine(LKBPRINT.PS_DASH, x,y,x+20*8,y, 4);


			x=10*8;
			y=60*8;
			LKBPRINT.LK_Rectangle(LKBPRINT.PS_DOT, x, y, x+50*8, y+20*8, 4);	
			x=70*8;
			y=60*8;
			LKBPRINT.LK_Rectangle(LKBPRINT.PS_SOLID, x, y, x+20*8, y+4, 4);	
			x=10*8;
			y=90*8;
			LKBPRINT.LK_Ellipse(LKBPRINT.PS_DOT, x, y, x+30*8, y+30*8, 4);	

			x=40*8;
			y=90*8;
			LKBPRINT.LK_DrawLine(LKBPRINT.PS_DASH, x,y,x+30*8,y+30*8, 4);
			x=50*8;
			y=90*8;
			LKBPRINT.LK_DrawLine(LKBPRINT.PS_DOT, x,y,x+30*8,y+30*8, 4);
			x=60*8;
			y=90*8;
			LKBPRINT.LK_DrawLine(LKBPRINT.PS_DASHDOT, x,y,x+30*8,y+30*8, 4);

			nHeight=56;
			x=50*8;
			y=52*8;
#if TRUE // Center Align Test
			LKBPRINT.LK_PrintWindowsFontAlign(1,y,0,nHeight,0,0,0,"Arial","Korea Mountain & River"); // Center Align
#else
		LKBPRINT.LK_PrintWindowsFontAlign(0,y,0,nHeight,0,0,0,"Arial","Korea Mountain & River"); // Left Align
#endif

			LKBPRINT.LK_EndPage();

			/* 4. LK_ClosePrinter() */
			LKBPRINT.LK_ClosePrinter();
		}

		private void btnPrintData_Click(object sender, System.EventArgs e)
		{
			long rtn;
			int x,y;

			/* 1. LK_OpenPrinter() */
			if(LKBPRINT.LK_OpenPrinter(cboPrinterName.Text) != LKBPRINT.LK_SUCCESS)
			{
				return;
			}

			/* 2. LK_SetupPrinter() */
			rtn=LKBPRINT.LK_SetupPrinter("101.6", 	// 10~104 (Unit is mm)
				"152.4", 		// 5~350 (Unit is mm)
				0,				// 0=Label with Gap, 1=Label with Black Mark, 2=Label with Continuous.
				"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
				"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
				8,				// 0 ~ 15
				6,				// 2 ~ 6 (Unit is Inch)
				1				// 1 ~ 9999 copies
				);

			if(rtn != LKBPRINT.LK_SUCCESS)
			{
				LKBPRINT.LK_ClosePrinter();
				return;
			}

			/* 3-1. page 1 test */
			LKBPRINT.LK_StartPage();
			x=50*8;
			y=50*8;
			/* 0  */
			LKBPRINT.LK_PrintDate(x,y,0,3*8,0,0,0,"Arial",0);
			/* 90  */
			LKBPRINT.LK_PrintDate(x,y,90,3*8,0,0,0,"Arial",0);
			/* 180  */
			LKBPRINT.LK_PrintDate(x,y,180,3*8,0,0,0,"Arial",0);
			/* 270  */
			LKBPRINT.LK_PrintDate(x,y,270,3*8,0,0,0,"Arial",0);

			x=50*8;
			y=80*8;
			LKBPRINT.LK_PrintDate(x,y,0,4*8,0,0,0,"Arial",0); y+=5*8;
			LKBPRINT.LK_PrintDate(x,y,0,4*8,0,0,0,"Arial",1); y+=5*8;
			LKBPRINT.LK_PrintDate(x,y,0,4*8,0,0,0,"Arial",2); y+=5*8;
			LKBPRINT.LK_PrintDate(x,y,0,4*8,0,0,0,"Arial",3); y+=5*8;
			LKBPRINT.LK_PrintDate(x,y,0,4*8,0,0,0,"Arial",4); y+=5*8;
			LKBPRINT.LK_PrintDate(x,y,0,4*8,0,0,0,"Arial",5); y+=5*8;
			LKBPRINT.LK_EndPage();

			/* 4. LK_ClosePrinter() */
			LKBPRINT.LK_ClosePrinter();
		}

		private void btnPrintTime_Click(object sender, System.EventArgs e)
		{
			long rtn;
			int x,y;

			/* 1. LK_OpenPrinter() */
			if(LKBPRINT.LK_OpenPrinter(cboPrinterName.Text) != LKBPRINT.LK_SUCCESS)
			{
				return;
			}

			/* 2. LK_SetupPrinter() */
			rtn=LKBPRINT.LK_SetupPrinter("101.6", 	// 10~104 (Unit is mm)
				"152.4", 		// 5~350 (Unit is mm)
				0,				// 0=Label with Gap, 1=Label with Black Mark, 2=Label with Continuous.
				"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
				"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
				8,				// 0 ~ 15
				6,				// 2 ~ 6 (Unit is Inch)
				1				// 1 ~ 9999 copies
				);

			if(rtn != LKBPRINT.LK_SUCCESS)
			{
				LKBPRINT.LK_ClosePrinter();
				return;
			}

			/* 3-1. page 1 test */
			LKBPRINT.LK_StartPage();
			x=50*8;
			y=50*8;
			/* 0  */
			LKBPRINT.LK_PrintTime(x,y,0,3*8,0,0,0,"Arial",1);
			/* 90  */
			LKBPRINT.LK_PrintTime(x,y,90,3*8,0,0,0,"Arial",1);
			/* 180  */
			LKBPRINT.LK_PrintTime(x,y,180,3*8,0,0,0,"Arial",1);
			/* 270  */
			LKBPRINT.LK_PrintTime(x,y,270,3*8,0,0,0,"Arial",1);

			x=50*8;
			y=80*8;
			LKBPRINT.LK_PrintTime(x,y,0,4*8,0,0,0,"Arial",0); y+=5*8;
			LKBPRINT.LK_PrintTime(x,y,0,4*8,0,0,0,"Arial",1); y+=5*8;
			LKBPRINT.LK_PrintTime(x,y,0,4*8,0,0,0,"Arial",2); y+=5*8;
			LKBPRINT.LK_PrintTime(x,y,0,4*8,0,0,0,"Arial",3); y+=5*8;
			LKBPRINT.LK_EndPage();

			/* 4. LK_ClosePrinter() */
			LKBPRINT.LK_ClosePrinter();
		}

		private void btnPrintPDF417_Click(object sender, System.EventArgs e)
		{
			string pdf417_data="SEWOO PDF417 TEST";
			long rtn;
			int x,y;
			int xwidthdot, ywidthdot;
			int	xdots, ydots;
			string	PDF417_Command;

			/* 1. LK_OpenPrinter() */
			if(LKBPRINT.LK_OpenPrinter(cboPrinterName.Text) != LKBPRINT.LK_SUCCESS)
			{
				return;
			}

			/* 2. LK_SetupPrinter() */
			rtn=LKBPRINT.LK_SetupPrinter("101.6", 	// 10~104 (Unit is mm)
				"152.4", 		// 5~350 (Unit is mm)
				0,				// 0=Label with Gap, 1=Label with Black Mark, 2=Label with Continuous.
				"3.1",			// if(MediaType==0) <GapHeight> else <BlackMarkHeight>. (Unit is mm)
				"0",			// if(MediaType==0) <not used> else <distance from BlackMark to perforation>. (Unit is mm)
				8,				// 0 ~ 15
				6,				// 2 ~ 6 (Unit is Inch)
				1				// 1 ~ 9999 copies
				);

			if(rtn != LKBPRINT.LK_SUCCESS)
			{
				LKBPRINT.LK_ClosePrinter();
				return;
			}

			/* 3-1. page 1 test */
			LKBPRINT.LK_StartPage();
			x=10*8;
			y=10*8;
			xdots = 3;
			ydots = xdots * 3;
			xwidthdot = 800; // ü  .( ū )
			ywidthdot = 400; // ü  .( ū )
			PDF417_Command = string.Format("b{0},{1},P,{2},{3},s0,c0,f0,x{4},y{5},l3,t0,o0,\"{6}\"\r\n", x, y, xwidthdot, ywidthdot, xdots, ydots, pdf417_data);
//			wsprintf(PDF417_Command, "b%d,%d,%c,%d,%d,s0,c0,f0,x%d,y%d,l3,t0,o0,\"%s\"\r\n", x, y, 'P', xwidthdot, ywidthdot, xdots, ydots, pdf417_data);
			LKBPRINT.LK_DirectCommand(PDF417_Command);
			LKBPRINT.LK_EndPage();

			/* 4. LK_ClosePrinter() */
			LKBPRINT.LK_ClosePrinter();		
		}

		private void btnExit_Click(object sender, System.EventArgs e)
		{
			this.Dispose(true);
		}
	}
}
